﻿$(document).on("pageinit", function () {
    $("div[data-questiontype='runningtotal'] .column").each(function () {
        var hasValues = false;

        $("input", $(this)).each(function () {
            hasValues = hasValues || ($(this).val() && $(this).val() != $(this).attr("data-default-value")) ? true : false;
        });

        ColumnChanged($(this), hasValues);
    });

    $("div[data-questiontype='runningtotal'] .column input[type='text']").on("blur", function () {
        ColumnChanged($(this).closest(".column"), true);
    });


    $("div[data-questiontype='runningtotal']").each(function () {
        var runningTotal = $(this);
        $('.questionClearButton', runningTotal).on("click", function (e) {
            $('input', runningTotal).val('');
            $('.summaryValue', runningTotal).text('0');

            e.preventDefault();
        });
    });
});

function ColumnChanged(column, validateBounds) {
    var columnSummary = column.find("span.summaryValue");
    var inputs = column.find("input[type='text']");

    var sum = _.reduce($.map(inputs, function (input) { var value = $(input).val(); return value ? parseFloat(value) : 0; }),
                    function (accumulator, value) { return accumulator + value; }, 0);

    if (isNaN(sum)) {
        columnSummary.text('');
    }
    else {
        columnSummary.text(sum);
    }

    if (validateBounds) {
        ValidateColumnBounds(column, sum);
    }
}

function ValidateColumnBounds(column, sum) {
    var lowerBound = $('.lowerBoundError', column);
    var upperBound = $('.upperBoundError', column);

    lowerBound.hide();
    upperBound.hide();

    if (lowerBound.length > 0 && sum < parseFloat(lowerBound.attr("data-lowerbound")) && (column.find("input[type='text']").filter(function () { return $(this).val(); }).length > 0)) {
        lowerBound.show();
    }
    else if (upperBound.length > 0 && sum > parseFloat(upperBound.attr("data-upperbound"))) {
        upperBound.show();
    }
}